import http.server
import socketserver
import os

PORT = 8001

class RangeHTTPRequestHandler(http.server.SimpleHTTPRequestHandler):
    """HTTP request handler with support for Range requests"""
    
    def end_headers(self):
        # Add CORS headers if needed
        self.send_header('Access-Control-Allow-Origin', '*')
        super().end_headers()

# Change to the directory where this script is located
os.chdir(os.path.dirname(os.path.abspath(__file__)))

with socketserver.TCPServer(("127.0.0.1", PORT), RangeHTTPRequestHandler) as httpd:
    print(f"Serving at http://127.0.0.1:{PORT}/")
    print(f"Open http://127.0.0.1:{PORT}/index.html in your browser")
    print("Press Ctrl+C to stop the server")
    try:
        httpd.serve_forever()
    except KeyboardInterrupt:
        print("\nServer stopped.")
